/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.config;

import com.cursee.monolib.core.config.SimpleConfigEntry;
import com.cursee.monolib.core.config.SimpleConfigParser;
import com.cursee.monolib.core.config.SimpleConfigWriter;
import com.cursee.monolib.platform.Services;
import com.cursee.monolib.util.toml.Keys;
import com.cursee.monolib.util.toml.Results;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleConfig {
    public Map<String, Object> values = new HashMap<String, Object>();
    private final SimpleConfig defaults;

    public SimpleConfig() {
        this(null);
    }

    public SimpleConfig(SimpleConfig defaults) {
        this(defaults, new HashMap<String, Object>());
    }

    private SimpleConfig(SimpleConfig defaults, Map<String, Object> values) {
        this.values = values;
        this.defaults = defaults;
    }

    public static SimpleConfig getOrCreateCommon(String modId, SimpleConfigEntry<?> ... references) {
        HashSet referenceSet = new HashSet(Set.of());
        referenceSet.addAll(Arrays.asList(references));
        return SimpleConfig.getOrCreateCommon(modId, referenceSet);
    }

    public static SimpleConfig getOrCreateClient(String modId, SimpleConfigEntry<?> ... references) {
        HashSet referenceSet = new HashSet(Set.of());
        referenceSet.addAll(Arrays.asList(references));
        return SimpleConfig.getOrCreateClient(modId, referenceSet);
    }

    public static SimpleConfig getOrCreateDedicatedServer(String modId, SimpleConfigEntry<?> ... references) {
        HashSet referenceSet = new HashSet(Set.of());
        referenceSet.addAll(Arrays.asList(references));
        return SimpleConfig.getOrCreateDedicatedServer(modId, referenceSet);
    }

    public static SimpleConfig getOrCreateCommon(String modId, Set<SimpleConfigEntry<?>> references) {
        File CONFIG_DIR = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
        CONFIG_DIR.mkdirs();
        File CONFIG_FILE = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + modId + "-common.toml");
        try {
            if (CONFIG_FILE.exists()) {
                return SimpleConfig.read(CONFIG_FILE);
            }
            HashMap defaults = new HashMap();
            references.forEach(simpleConfigEntry -> defaults.put(simpleConfigEntry.getKey(), simpleConfigEntry.getValue()));
            return SimpleConfig.writeWithReturn(defaults, CONFIG_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SimpleConfig getOrCreateClient(String modId, Set<SimpleConfigEntry<?>> references) {
        File CONFIG_DIR = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
        CONFIG_DIR.mkdirs();
        File CONFIG_FILE = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + modId + "-client.toml");
        try {
            if (CONFIG_FILE.exists()) {
                return SimpleConfig.read(CONFIG_FILE);
            }
            HashMap defaults = new HashMap();
            references.forEach(simpleConfigEntry -> defaults.put(simpleConfigEntry.getKey(), simpleConfigEntry.getValue()));
            return SimpleConfig.writeWithReturn(defaults, CONFIG_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SimpleConfig getOrCreateDedicatedServer(String modId, Set<SimpleConfigEntry<?>> references) {
        File CONFIG_DIR = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
        CONFIG_DIR.mkdirs();
        File CONFIG_FILE = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + modId + "-server.toml");
        try {
            if (CONFIG_FILE.exists()) {
                return SimpleConfig.read(CONFIG_FILE);
            }
            HashMap defaults = new HashMap();
            references.forEach(simpleConfigEntry -> defaults.put(simpleConfigEntry.getKey(), simpleConfigEntry.getValue()));
            return SimpleConfig.writeWithReturn(defaults, CONFIG_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(Map<String, ?> from, File target) throws IOException {
        SimpleConfigWriter.writeObjectToFile(from, target);
    }

    public static SimpleConfig writeWithReturn(Map<String, ?> from, File target) throws IOException {
        return SimpleConfigWriter.writeObjectToFileWithReturn(from, target);
    }

    public static SimpleConfig read(File file) {
        try {
            return SimpleConfig.attemptInputStreamReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SimpleConfig attemptInputStreamReader(Reader reader) {
        SimpleConfig simpleConfig;
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            StringBuilder w = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                w.append(line).append('\n');
                line = bufferedReader.readLine();
            }
            simpleConfig = SimpleConfig.getTomlFromString(w.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bufferedReader.close();
        return simpleConfig;
    }

    private static SimpleConfig getTomlFromString(String tomlString) throws IllegalStateException {
        SimpleConfig config = new SimpleConfig();
        Results results = SimpleConfigParser.run(tomlString);
        if (results.errors.hasErrors()) {
            throw new IllegalStateException(results.errors.toString());
        }
        config.values = results.consume();
        return config;
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getString(String key, String defaultValue) {
        String val = this.getString(key);
        return val == null ? defaultValue : val;
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Long getLong(String key, Long defaultValue) {
        Long val = this.getLong(key);
        return val == null ? defaultValue : val;
    }

    public <T> List<T> getList(String key) {
        List list = (List)this.get(key);
        return list;
    }

    public <T> List<T> getList(String key, List<T> defaultValue) {
        List<T> list = this.getList(key);
        return list != null ? list : defaultValue;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean val = this.getBoolean(key);
        return val == null ? defaultValue : val;
    }

    public Date getDate(String key) {
        return (Date)this.get(key);
    }

    public Date getDate(String key, Date defaultValue) {
        Date val = this.getDate(key);
        return val == null ? defaultValue : val;
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public Double getDouble(String key, Double defaultValue) {
        Double val = this.getDouble(key);
        return val == null ? defaultValue : val;
    }

    public SimpleConfig getTable(String key) {
        Map map = (Map)this.get(key);
        return map != null ? new SimpleConfig(null, map) : null;
    }

    public List<SimpleConfig> getTables(String key) {
        List tableArray = (List)this.get(key);
        if (tableArray == null) {
            return null;
        }
        ArrayList<SimpleConfig> tables = new ArrayList<SimpleConfig>();
        for (Map table : tableArray) {
            tables.add(new SimpleConfig(null, table));
        }
        return tables;
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public boolean containsPrimitive(String key) {
        Object object = this.get(key);
        return object != null && !(object instanceof Map) && !(object instanceof List);
    }

    public boolean containsTable(String key) {
        Object object = this.get(key);
        return object != null && object instanceof Map;
    }

    public boolean containsTableArray(String key) {
        Object object = this.get(key);
        return object != null && object instanceof List;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    private Object get(String key) {
        Keys.Key[] keys;
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        HashMap<String, Object> current = new HashMap<String, Object>(this.values);
        for (Keys.Key checkedKey : keys = Keys.split(key)) {
            if (checkedKey.index == -1 && current instanceof Map && ((Map)current).containsKey(checkedKey.path)) {
                return ((Map)current).get(checkedKey.path);
            }
            current = ((Map)current).get(checkedKey.name);
            if (checkedKey.index > -1 && current != null) {
                if (checkedKey.index >= ((List)((Object)current)).size()) {
                    return null;
                }
                current = ((List)((Object)current)).get(checkedKey.index);
            }
            if (current != null) continue;
            return this.defaults != null ? this.defaults.get(key) : null;
        }
        return current;
    }
}

